/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: ResetDlg.h $
   Last Modification:
    $Author: MichaelT $
    $Modtime: 5.07.06 9:40 $
    $Revision: 436 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    Device Reset Dialog
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        05.07.2006  MT       initial version
 
**************************************************************************************/

///////////////////////////////////////////////////////////////////////////////////////////
/// \file ResetDlg.h
///   Device Reset Dialog
///////////////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "BaseDialog.h"
#include "afxwin.h"

///////////////////////////////////////////////////////////////////////////////////////////
/// Device Reset Dialog
///////////////////////////////////////////////////////////////////////////////////////////
class CResetDlg : public CBaseDialog
{
	DECLARE_DYNAMIC(CResetDlg)

public:
	CResetDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CResetDlg();

  void ThreadFunction(void);
  void OnUpdateDevice(CCifXDeviceBase* pcDevice);

// Dialog Data
	enum { IDD = IDD_RESET };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

  unsigned long   m_ulTimeout;      //!< Timeout for reset
  unsigned long   m_ulResetMode;    //!< Mode to pass to reset command

  CComboBox       m_cResetModeCtrl; //!< Reset mode combobox control

	DECLARE_MESSAGE_MAP()
public:
  virtual BOOL OnInitDialog();
  afx_msg void OnCbnSelchangeCbReset();
  afx_msg void OnEnKillfocusEdtTimeout();
  afx_msg void OnBnClickedBtnReset();
};
